; =============================================================================
; MDKRLE.asm - MDK-RLE Decompression Routine
; =============================================================================
; RLE compression by Marcel de Kogel (1998)
; Z80 decompressor code is required here.
; =============================================================================
; IN: HL -> Source compressed data
;     DE -> Destination VRAM address
; =============================================================================
mdkrle_decompress:
    call vdp_set_write_addr
    ld      c, $be
mdkrle_main_loop:
    ld      a,(hl)
    inc     hl
    cp      $ff
    ret     z
    bit     7,a
    jr      z,mdkrle_handle_rle
    and     $7f
    inc     a
    ld      b,a
    ld      a,(hl)
    inc     hl
mdkrle_handle_raw_loop:
    out     (c),a
    nop
    nop
    djnz    mdkrle_handle_raw_loop
    jr      mdkrle_main_loop
mdkrle_handle_rle:
    inc     a
    ld      b,a
mdkrle_handle_rle_loop:
    outi
    jr      z, mdkrle_main_loop
    jp      mdkrle_handle_rle_loop